"""\
script to automaticly extract typedefs and enums
from preprocessed include file
"""
# Problems?: no support for:
# comments (preproc eats them?)
# quoting strings etc.
# ; not at eol
#
import re,sys

comnt_exp = re.compile(r"#.*")
termline_exp = re.compile(r"(.*);\s*")
blocklvl_exp = re.compile(r"({|})")
lvl_add = {"{":1,"}":-1}
typedef_exp = re.compile(r"(?s)\s*typedef\s+(?P<val>.*\S)\s+(?P<key>\w+)")
enum_exp = re.compile(r"(?s)\s*enum\s+(?P<key>\w+)\s+{(?P<vals>.+)}")

ct_types = {
    "char":"c_char",
    "unsigned char":"c_uchar",
    "signed char":"c_byte",
    "int":"c_int",
    "signed int":"c_int",
    "unsigned int":"c_uint",
    "long":"c_long",
    "unsigned long":"c_ulong"
    }

fribidi_types = [
    "FriBidiChar","FriBidiStrIndex","FriBidiCharType",
    "FriBidiLevel",
    "fribidi_boolean",
    #"FriBidiList"
    ]

fribidi_enums = ["FriBidiPropEnum"]

manual_structs = """\

class FriBidiRunType(Structure):
    _fields_ = [("length", FriBidiStrIndex),
                ("attribute", POINTER(None))]
__all__.append('FriBidiRunType')

class FriBidiList(Structure):
    pass

FriBidiList._fields_ = [("data",POINTER(None)),
                        ("next",POINTER(FriBidiList)),
                        ("prev",POINTER(FriBidiList))]
__all__.append('FriBidiList')
"""

def get_cline(fp):
    line = ""
    block_lvl = 0
    for l in fp:
        if comnt_exp.match(l): continue
        
        for m in blocklvl_exp.finditer(l):
            block_lvl += lvl_add[m.group(1)]
        
        if block_lvl<=0:
            m = termline_exp.match(l)
            if m:
                line += m.group(1)
                break
        
        line += l
    
    return line

def get_c_dicts(filename):
    f = open(filename)
    tdict = {}
    edict = {}
    l = get_cline(f)
    while (l):
        m = typedef_exp.match(l)
        if m:
            d = m.groupdict()
            tdict[d['key']] = d['val']
        else:
            n = enum_exp.match(l)
            if n:
                d = n.groupdict()
                vals = ''.join(d['vals'].split()).split(',')
                edict[d['key']] = vals
        
        l = get_cline(f)
    
    return tdict,edict

def deep_get(dict,key):
    val = dict.get(key)
    while dict.has_key(val):
        val = dict.get(val)
    return val

def prt_py_code(filename):
    typs,enums = get_c_dicts(filename)
    print "from ctypes import *"
    print "__all__ = []"
    
    typs.update(ct_types)
    for t in fribidi_types:
        print "%s = %s"%(t,deep_get(typs,t))
        print "__all__.append('%s')"%t
    print
    
    for e in fribidi_enums:
        print "%s = range(%d)"%\
              (",".join(enums[e]),len(enums[e]))
        print "__all__.extend([%s])" %\
              ",".join(["'%s'"%x for x in enums[e]])
        
        print "\n%s = {"%e
        print ",\n".join(["    '%s':%d"%(x[1],x[0]) for x in enumerate(enums[e])])
        print "    }"
        print "__all__.append('%s')"%e
    
    # structs: currently do manually
    print manual_structs

if __name__=="__main__":
    prt_py_code(sys.argv[1])
