"""\
script to automaticly extract declarations
from the fribidi.h header
"""
import re,sys

helpstart_exp = re.compile("/\*=====")
helpend_exp = re.compile("----\*/")
comntline_exp = re.compile("\s?(\* )?(.*)")
funcdecl_exp = re.compile(r"\s*FRIBIDI_API\s+(?P<restype>\w+)\s+(?P<funcname>\w+)\s*\(")
funcend_exp = re.compile(r"\)\s*;")
param_exp = re.compile(r"\s*(/\*\s*(?P<help>.*)\s*\*/)?\s*(?P<type>\w+)\s*(?P<stars>(\*\s*)*)((?P<varname>\w+)\s*(?P<dims>(\[\s*\d+\s*\]\s*)*))?")

typeconv = {"void":"None",
            "int":"c_int"}

HEAD = """\
import ctypes
from ctypes import *
_fribidi = ctypes.cdll.fribidi
from fb_types import *

__all__ = []
"""
def cpdict(d):
    t = {}
    t.update(d)
    return t

def parse_params(prms):
    if prms.split()==["void"]: return []
    res = [param_exp.match(x).groupdict() for x in prms.split(",")]
    for d in res:
        tp = d["type"]
        d["type"] = typeconv.get(tp,tp)
        
        if d["stars"] is not None:
            d["stars"] = d["stars"].count("*")
        else: d["stars"] = 0
        
        if d["dims"]:
            d["dims"] = re.split(r"[\[\]\s]*",d["dims"])[1:-1]
    return res

def out_parm(prm,ind=""):
    s = prm["type"]
    
    for x in xrange(prm["stars"]): s="POINTER(%s)"%s
    if prm["dims"]:
        for i in xrange(len(prm["dims"])-1,-1,-1):
            s = "(%s * %s)"%(s,prm["dims"][i])
    
    if prm["help"]:
        s = "# %s\n%s"%(prm["help"],ind+s)
    
    s = ind + s
    return s

def out_all(funcs,ind=""):
    print "\n".join([ind+x for x in HEAD.splitlines()])
    for f in funcs:
        print
        assert f["funcname"].startswith("fribidi_")
        fname = f["funcname"][len("fribidi_"):]
        print "__all__.append('%s')"%fname
        print ind+"%s = _fribidi.fribidi_%s"%(fname,fname)
        if f["help"]:
            print ind+"%s.__doc__ = '''\\"%fname
            print f["help"]
            print "'''"
            #print "\n".join([ind+"#"+x for x in f["help"].splitlines()])
            #print ind+"#"
        
        print ind+"%s.argtypes = [\\"%fname
        iind = ind+" "*4
        for arg in f["params"][:-1]:
            s = out_parm(arg,iind)+" ,"
            if arg["varname"]:
                s = "%s # %s"%(s,arg["varname"])
            print s
        
        for arg in f["params"][-1:]:
            s = out_parm(arg,iind)
            if arg["varname"]:
                s = "%s # %s"%(s,arg["varname"])
            print s
        
        print iind+"]"
        
        print ind+"%s.restype = %s" % (fname, f["restype"])

def extract_decls(fp):
    mode = "none"
    cur_help = ""
    decls = []
    for l in fp:
        while l:
            if mode=="none":
                m = funcdecl_exp.match(l)
                if m:
                    d = m.groupdict()
                    d["params"]=""
                    rt = d["restype"]
                    d["restype"] = typeconv.get(rt,rt)
                    decls.append(d)
                    
                    l = l[m.end():]
                    mode = "decl"
                    continue
                m = helpstart_exp.match(l)
                if m:
                    mode = "help"
                    cur_help=""
                
                l = ""
                continue
            
            elif mode=="help":
                m = helpend_exp.search(l)
                if m:
                    mode="none"
                    l = ""
                    continue
                
                m = comntline_exp.match(l)
                if m:
                    cur_help = "\n".join([cur_help,m.group(2)])
                
                l =""
                continue
            
            elif mode=="decl":
                m = funcend_exp.search(l)
                if m:
                    decls[-1]["params"] += l[:m.start()]
                    decls[-1]["params"] = parse_params(decls[-1]["params"])
                    l = l[m.end():]
                    decls[-1]["help"] = cur_help
                    cur_help = ""
                    mode = "none"
                    continue
                
                decls[-1]["params"] += l
                
                l = ""
                continue
            #end if mode
        #end while l
    #end for l
    
    return decls

if __name__ == "__main__":
    dd = extract_decls(open(sys.argv[1]))
    out_all(dd)
