import inspect
import ctypes

_CdeclFuncPtr = type(ctypes.cdll.fribidi.fribidi_log2vis)

#ctypes tools
def reinterpret_cast(typ,obj):
    return typ.from_address(addressof(obj))

def alloc(typ, size, init=()):
    a = (typ * size)(*init)
    ptr = pointer(typ.from_address(addressof(a)))
    ptr._array = a
    return ptr

# Inspect patch:
# makes help() work for ctypes functions too.
orig_isbuiltin = inspect.isbuiltin

def my_isbuiltin(obj):
    "fribidi_py patch for isbuiltin - makes help() work for ctypes funcs"
    return isinstance(obj,_CdeclFuncPtr) or orig_isbuiltin(obj)

def install_inspect_patch():
    inspect.isbuiltin = my_isbuiltin

def uninstall_inspect_patch():
    inspect.isbuiltin = orig_isbuiltin
